// MultiplexerDlg.h : header file
//

#if !defined(AFX_MULTIPLEXERDLG_H__1E45C232_80F2_4A27_BD13_B7B817059318__INCLUDED_)
#define AFX_MULTIPLEXERDLG_H__1E45C232_80F2_4A27_BD13_B7B817059318__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include "ChannelWindow.h"

#include "ControlPnael.h"


#pragma once
// a menu class for each CQSecurityDemoDlg
typedef struct tagMenuInfo
{
	BYTE nSourceType;

	BYTE nResolutionType;
	
	BOOL nStandardType;	

} MenuInfo, *pMenuInfo;

/////////////////////////////////////////////////////////////////////////////
// CMultiplexerDlg dialog

class CMultiplexerDlg : public CDialog
{
// Construction
public:
	CMultiplexerDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CMultiplexerDlg)
	enum { IDD = IDD_MULTIPLEXER_DIALOG };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMultiplexerDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CMultiplexerDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnDestroy();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnMenuCsourcHdmi();
	afx_msg void OnMenuCsourcComponents();
	afx_msg void OnMenuCsourcDvia();
	afx_msg void OnMenuCsourcDvid();
	afx_msg void OnMenuCsourcSdi();
	afx_msg void OnMenuStandardNtsc();
	afx_msg void OnMenuStandardPal();
	afx_msg void OnMenuResolution1920x1080();
	afx_msg void OnMenuResolution1280x720();
	afx_msg void OnMenuResolution720x480();
	afx_msg void OnMenuResolution720x576();
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:

	//
	// user interface function
	//

	BOOL				OnRButtonDown_CChannelWindow( ULONG nChannelNum, CPoint point, CWnd *pWnd);

	BOOL				SetSplitWindowLocation( CRect *poWindowRect /* channel rect */, ULONG nWindowNumber , ULONG nGridDivisions, ULONG nRendererWidth, ULONG nRendererHeight );
	
	BOOL				OnLButtonDown_CChannelWindow( ULONG nChannelNum, UINT nFlags, CPoint point );
	
	BOOL				OnMenuItemDown_ChangeSource( ULONG nType, ULONG nChannelNum );

	BOOL				OnMenuItemDown_ChangeStandard( ULONG nType, ULONG nChannelNum );

	BOOL				OnMenuItemDown_ChangeResolution( ULONG nType, ULONG nChannelNum );


	//
	// device function
	// 

	BOOL				HwUnInitialize();

	BOOL				HwInitialize();

	//
	// user interface property
	// 	

	CChannelWindow		m_oChannelWindow_LIVE[ 9 * 9 ];					// LIVE STREAM DISPLAY WINDOW	

	MenuInfo			m_oMenuInfo[ 9 * 9 ];
	
	CControlPnael		m_oControlPanelDlg;															

	ULONG				m_nDisplayModeNumber;													// DISPLAY MODE EXCHANGE (0 = LIVE / 1 = RCPB)

	ULONG				m_nAudioPlayChannel;	
	
	BOOL				m_nWndState;

	BYTE				m_nWndowLayoutType;

	BYTE				m_nMainWindowNum;

	///////////////////////////////////////////////////////////////

	// used in CVRSDK 

	PVOID				m_pCustomVideoRenderer[ 9 * 9 ];

	PVOID				m_pCustomChannelWindow[ 9 * 9 ];

	PVOID				m_pOverlayWindowTime;

	PVOID				m_pOverlayWindow;

	//
	// device property
	// 
	
	DEVICE_HANDLE		m_hVideoDevice[ 9 * 9 ];								// VIDEO STREAM CAPTURE DEVICE
	
	DEVICE_HANDLE		m_hAudioDevice[ 9 * 9 ];								// AUDIO STREAM DECODER DEVICE

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MULTIPLEXERDLG_H__1E45C232_80F2_4A27_BD13_B7B817059318__INCLUDED_)
